/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.internal.runner.listener;

import android.app.Instrumentation;
import android.os.Bundle;
import android.support.test.internal.runner.listener.InstrumentationRunListener;
import android.util.Log;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.junit.runner.Result;

public class CoverageListener
extends InstrumentationRunListener {
    private String mCoverageFilePath;
    private static final String REPORT_KEY_COVERAGE_PATH = "coverageFilePath";
    private static final String DEFAULT_COVERAGE_FILE_NAME = "coverage.ec";
    private static final String LOG_TAG = null;

    public CoverageListener(String customCoverageFilePath) {
        this.mCoverageFilePath = customCoverageFilePath;
    }

    @Override
    public void setInstrumentation(Instrumentation instr) {
        super.setInstrumentation(instr);
        if (this.mCoverageFilePath == null) {
            this.mCoverageFilePath = instr.getTargetContext().getFilesDir().getAbsolutePath() + File.separator + DEFAULT_COVERAGE_FILE_NAME;
        }
    }

    @Override
    public void instrumentationRunFinished(PrintStream writer, Bundle results, Result junitResults) {
        this.generateCoverageReport(writer, results);
    }

    private void generateCoverageReport(PrintStream writer, Bundle results) {
        File coverageFile = new File(this.mCoverageFilePath);
        try {
            Class<?> emmaRTClass = Class.forName("com.vladium.emma.rt.RT");
            Method dumpCoverageMethod = emmaRTClass.getMethod("dumpCoverageData", coverageFile.getClass(), Boolean.TYPE, Boolean.TYPE);
            dumpCoverageMethod.invoke(null, coverageFile, false, false);
            results.putString(REPORT_KEY_COVERAGE_PATH, this.mCoverageFilePath);
            writer.format("\nGenerated code coverage data to %s", this.mCoverageFilePath);
        }
        catch (ClassNotFoundException e) {
            this.reportEmmaError(writer, "Is emma jar on classpath?", e);
        }
        catch (SecurityException e) {
            this.reportEmmaError(writer, e);
        }
        catch (NoSuchMethodException e) {
            this.reportEmmaError(writer, e);
        }
        catch (IllegalArgumentException e) {
            this.reportEmmaError(writer, e);
        }
        catch (IllegalAccessException e) {
            this.reportEmmaError(writer, e);
        }
        catch (InvocationTargetException e) {
            this.reportEmmaError(writer, e);
        }
    }

    private void reportEmmaError(PrintStream writer, Exception e) {
        this.reportEmmaError(writer, "", e);
    }

    private void reportEmmaError(PrintStream writer, String hint, Exception e) {
        String msg = "Failed to generate emma coverage. " + hint;
        Log.e((String)LOG_TAG, (String)msg, (Throwable)e);
        writer.format("\nError: %s", msg);
    }
}

