package com.example.sadievrenseker.myapplication;

import android.os.Parcel;
import android.os.Parcelable;

import java.io.Serializable;

/**
 * Created by sadievrenseker on 2/6/17.
 */

public class Pet implements Parcelable {
    String name;
    int weight;
    int hunger_level;
    String color;
    int sleep_level;
    int happiness_level;
    int action_points;

    public Pet(int weight,int hunger_level, int sleep_level, int happiness_level, int action_points){
        this.weight=weight;
        this.hunger_level=hunger_level;
        this.sleep_level=sleep_level;
        this.happiness_level=happiness_level;
        this.action_points=action_points;
    }
    public String feed(){
        if(action_points>0) {
            hunger_level--;
            weight++;
            action_points--;
            sleep_level--;
            happiness_level--;
            return "pet feeded";
        }
        else
            return "You dont have enough action points";
    }
    public String sleep(){
        if(action_points>0) {
            sleep_level++;
            action_points--;
            happiness_level--;
            return "pet slept";
        }
        else
            return "You dont have enough action points";
    }

    public String play(){
        if(action_points>0) {
            happiness_level++;
            action_points--;
            sleep_level--;
            return "you played with the pet ";
        }
        else
            return "You dont have enough action points";
    }

    public String stats(){

        return "Name : "+ name+
                " \n weight : " + weight
                + " \n hunger level :" + hunger_level
                + " \n sleep level :"+ sleep_level
                + " \n happiness level :"+ happiness_level
                +" \n action points left :"+ action_points;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.name);
        dest.writeInt(this.weight);
        dest.writeInt(this.hunger_level);
        dest.writeString(this.color);
        dest.writeInt(this.sleep_level);
        dest.writeInt(this.happiness_level);
        dest.writeInt(this.action_points);
    }

    protected Pet(Parcel in) {
        this.name = in.readString();
        this.weight = in.readInt();
        this.hunger_level = in.readInt();
        this.color = in.readString();
        this.sleep_level = in.readInt();
        this.happiness_level = in.readInt();
        this.action_points = in.readInt();
    }

    public static final Parcelable.Creator<Pet> CREATOR = new Parcelable.Creator<Pet>() {
        @Override
        public Pet createFromParcel(Parcel source) {
            return new Pet(source);
        }

        @Override
        public Pet[] newArray(int size) {
            return new Pet[size];
        }
    };
}
