package com.example.sadievrenseker.myapplication;

import android.content.Intent;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.util.Log;
public class MainActivity extends AppCompatActivity implements View.OnClickListener{
    TextView messages;
    Button sleep;
    Button play;
    Button feed;
    Pet myPet;
    TextView stats;
    EditText name_input;
    int counter = 0;

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable("petinformation",myPet);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        stats= (TextView) findViewById(R.id.stats);
        if(savedInstanceState!=null){
            myPet = savedInstanceState.getParcelable("petinformation");
            stats.setVisibility(View.VISIBLE);
        }
        else{
            myPet = new Pet(10,0,5,5,10);
        }

        sleep= (Button) findViewById(R.id.sleep_button);
        play =(Button) findViewById(R.id.play_button);
        feed = (Button) findViewById(R.id.feed_button);
        Button score = (Button)findViewById(R.id.scoreButton);
        score.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent i = new Intent(MainActivity.this,scoreScreen.class);
                i.putExtra("petinfo",myPet);
                startActivity(i);

            }
        });
        sleep.setOnClickListener(this);
        play.setOnClickListener(this);
        feed.setOnClickListener(this);

        stats.setText(myPet.stats());
         messages = (TextView) findViewById(R.id.messages);
        name_input = (EditText) findViewById(R.id.editText2);
        name_input.setOnEditorActionListener(new TextView.OnEditorActionListener() {
            @Override
            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                myPet.name=name_input.getText().toString();
                stats.setText(myPet.stats());
                stats.setVisibility(View.VISIBLE);
                return false;
            }
        });
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Log.d("destroy","destroy");
    }

    @Override
    protected void onStop() {
        super.onStop();
        Log.d("destroy","stop");
    }

    @Override
    protected void onStart() {
        super.onStart();
        Log.d("destroy","start");
    }

    @Override
    protected void onPause() {
        super.onPause();
        Log.d("destroy","pause");
    }

    @Override
    protected void onResume() {
        super.onResume();
        Log.d("destroy","resume");
    }

    public void onClick(View v){

        if(v.getId()==sleep.getId()){
            messages.setText(myPet.sleep());
        }
        else if (v.getId()==play.getId()){
            messages.setText( myPet.play());
        }
        else if (v.getId()== feed.getId()) {
            messages.setText(myPet.feed());
        }
        stats.setText(myPet.stats());
    }


}
