/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.internal.runner;

import android.app.Instrumentation;
import android.os.Bundle;
import android.support.test.internal.runner.TestRequest;
import android.support.test.internal.runner.listener.InstrumentationRunListener;
import android.support.test.internal.util.Checks;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public final class TestExecutor {
    private static final String LOG_TAG = "TestExecutor";
    private final List<RunListener> mListeners;
    private final Instrumentation mInstr;

    private TestExecutor(Builder builder) {
        this.mListeners = Checks.checkNotNull(builder.mListeners);
        this.mInstr = builder.mInstr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle execute(TestRequest testRequest) {
        ByteArrayOutputStream summaryStream;
        Bundle resultBundle = new Bundle();
        Result junitResults = new Result();
        try {
            JUnitCore testRunner = new JUnitCore();
            this.setUpListeners(testRunner);
            junitResults = testRunner.run(testRequest.getRequest());
            junitResults.getFailures().addAll(testRequest.getFailures());
            summaryStream = new ByteArrayOutputStream();
            PrintStream summaryWriter = new PrintStream(summaryStream);
            this.reportRunEnded(this.mListeners, summaryWriter, resultBundle, junitResults);
            summaryWriter.close();
        }
        catch (Throwable t) {
            ByteArrayOutputStream summaryStream2;
            try {
                String msg = "Fatal exception when running tests";
                Log.e((String)LOG_TAG, (String)"Fatal exception when running tests", (Throwable)t);
                junitResults.getFailures().add(new Failure(Description.createSuiteDescription((String)"Fatal exception when running tests", (Annotation[])new Annotation[0]), t));
                summaryStream2 = new ByteArrayOutputStream();
                PrintStream summaryWriter = new PrintStream(summaryStream2);
                this.reportRunEnded(this.mListeners, summaryWriter, resultBundle, junitResults);
                summaryWriter.close();
            }
            catch (Throwable throwable) {
                ByteArrayOutputStream summaryStream3 = new ByteArrayOutputStream();
                PrintStream summaryWriter = new PrintStream(summaryStream3);
                this.reportRunEnded(this.mListeners, summaryWriter, resultBundle, junitResults);
                summaryWriter.close();
                resultBundle.putString("stream", String.format("\n%s", summaryStream3.toString()));
                throw throwable;
            }
            resultBundle.putString("stream", String.format("\n%s", summaryStream2.toString()));
        }
        resultBundle.putString("stream", String.format("\n%s", summaryStream.toString()));
        return resultBundle;
    }

    private void setUpListeners(JUnitCore testRunner) {
        for (RunListener listener : this.mListeners) {
            Log.d((String)LOG_TAG, (String)("Adding listener " + listener.getClass().getName()));
            testRunner.addListener(listener);
            if (!(listener instanceof InstrumentationRunListener)) continue;
            ((InstrumentationRunListener)listener).setInstrumentation(this.mInstr);
        }
    }

    private void reportRunEnded(List<RunListener> listeners, PrintStream summaryWriter, Bundle resultBundle, Result jUnitResults) {
        for (RunListener listener : listeners) {
            if (!(listener instanceof InstrumentationRunListener)) continue;
            ((InstrumentationRunListener)listener).instrumentationRunFinished(summaryWriter, resultBundle, jUnitResults);
        }
    }

    public static class Builder {
        private final List<RunListener> mListeners = new ArrayList<RunListener>();
        private final Instrumentation mInstr;

        public Builder(Instrumentation instr) {
            this.mInstr = instr;
        }

        public Builder addRunListener(RunListener listener) {
            this.mListeners.add(listener);
            return this;
        }

        public TestExecutor build() {
            return new TestExecutor(this);
        }
    }
}

