package com.example.sadievrenseker.mypaint;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;

/**
 * Created by sadievrenseker on 3/1/17.
 */

public class paintScreen extends View {
    Paint myPaint = new Paint();
    Path myPath = new Path();
    int counter =0;
    boolean secondClick=false;
    int activeTool=0;
    float lastX,lastY;
    public paintScreen(Context c){
        super(c);
        myPaint.setColor(Color.BLACK);
        myPaint.setAntiAlias(true);


    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawPath(myPath,myPaint);

    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        counter++;
        if(counter%2==0) return true;
        float x = event.getX();
        float y = event.getY();
        if(x<50&&y<50){ // change the current tool
            if(activeTool==0) {
                activeTool = 1;
                Log.d("msg","tool updated to 1");
                invalidate();
                return true;
            }
            else {
                activeTool = 0;
                Log.d("msg","tool updated to 0");
                invalidate();
                return true;
            }
        }
        else{ // draw something
        if(activeTool==0){ // draw in free style
             myPath.addCircle(x,y,10, Path.Direction.CW);
            invalidate();
            return true;
        }
        else if(activeTool==1) { //draw rectangle
            if (secondClick == false) {
                lastX = event.getX();
                lastY = event.getY();
                secondClick = true;
                invalidate();
                return true;
            } else {

                myPath.addRect(lastX, lastY, x, y, Path.Direction.CW);
                secondClick = false;
                invalidate();
                return true;

            }
        }
        }
        return true;
    }
}





