/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.rule.logging;

import android.os.Build;
import android.os.Trace;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.test.annotation.Beta;
import android.support.test.rule.logging.LoggingBaseRule;
import android.support.test.rule.logging.RuleLoggingUtils;
import android.util.Log;
import java.io.File;
import java.io.IOException;

@Beta
public class LogLogcatRule
extends LoggingBaseRule {
    private static final String TAG = "LogLogcatRule";
    private static final String DEFAULT_LOG_FILE_NAME = "logcat.log";

    public LogLogcatRule() {
    }

    public LogLogcatRule(@NonNull File logFileOutputDirectory, @Nullable String fileName) {
        super(logFileOutputDirectory, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpLogcat(File logFile) {
        Process process = null;
        try {
            if (Build.VERSION.SDK_INT >= 18) {
                Trace.beginSection((String)"Recording logcat");
            }
            process = RuleLoggingUtils.startProcess(new String[]{"logcat", "-d", "-f", logFile.getAbsolutePath()});
            process.waitFor();
        }
        catch (IOException | InterruptedException exception) {
            RuleLoggingUtils.writeErrorToFileAndLogcat(logFile, TAG, "Error recording logcat output.", exception);
        }
        finally {
            if (process != null) {
                process.destroy();
            }
            if (Build.VERSION.SDK_INT >= 18) {
                Trace.endSection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearLogcat() {
        Process process = null;
        try {
            process = RuleLoggingUtils.startProcess(new String[]{"logcat", "-c"});
            process.waitFor();
            if (process.exitValue() != 0) {
                throw new IllegalStateException("Error while clearing logcat, exitValue=" + process.exitValue());
            }
        }
        catch (IOException | IllegalStateException | InterruptedException exception) {
            Log.e((String)TAG, (String)"Exception clearing logcat.", (Throwable)exception);
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        Log.i((String)TAG, (String)"Logcat cleared by test rule");
    }

    @Override
    public void afterTest() {
        this.dumpLogcat(this.getLogFileName());
    }

    @Override
    public void beforeTest() {
        LogLogcatRule.clearLogcat();
    }

    public File dumpLogcat(String logFileName) {
        File logFile = null == this.getLogFileOutputDirectory() ? RuleLoggingUtils.getTestFile(this.getTestClass(), this.getTestName(), logFileName, this.getTestRunNumber()) : new File(this.getLogFileOutputDirectory(), logFileName);
        LogLogcatRule.dumpLogcat(logFile);
        return logFile;
    }

    @Override
    public String getDefaultLogFileName() {
        return DEFAULT_LOG_FILE_NAME;
    }
}

