/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.fd.runtime;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.net.LocalServerSocket;
import android.net.LocalSocket;
import android.util.Log;
import com.android.tools.fd.runtime.AppInfo;
import com.android.tools.fd.runtime.ApplicationPatch;
import com.android.tools.fd.runtime.FileManager;
import com.android.tools.fd.runtime.MonkeyPatcher;
import com.android.tools.fd.runtime.PatchesLoader;
import com.android.tools.fd.runtime.Restarter;
import dalvik.system.DexClassLoader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.List;

public class Server {
    private static final boolean RESTART_LOCALLY = false;
    private static final boolean POST_ALIVE_STATUS = false;
    private LocalServerSocket mServerSocket;
    private final Application mApplication;
    private static int sWrongTokenCount;

    public static void create(String packageName, Application application) {
        new Server(packageName, application);
    }

    private Server(String packageName, Application application) {
        this.mApplication = application;
        try {
            this.mServerSocket = new LocalServerSocket(packageName);
            if (Log.isLoggable((String)"InstantRun", (int)2)) {
                Log.v((String)"InstantRun", (String)("Starting server socket listening for package " + packageName + " on " + this.mServerSocket.getLocalSocketAddress()));
            }
        }
        catch (IOException e) {
            Log.e((String)"InstantRun", (String)("IO Error creating local socket at " + packageName), (Throwable)e);
            return;
        }
        this.startServer();
        if (Log.isLoggable((String)"InstantRun", (int)2)) {
            Log.v((String)"InstantRun", (String)("Started server for package " + packageName));
        }
    }

    private void startServer() {
        block2: {
            try {
                Thread socketServerThread = new Thread(new SocketServerThread());
                socketServerThread.start();
            }
            catch (Throwable e) {
                if (!Log.isLoggable((String)"InstantRun", (int)6)) break block2;
                Log.e((String)"InstantRun", (String)"Fatal error starting Instant Run server", (Throwable)e);
            }
        }
    }

    private static boolean isResourcePath(String path) {
        return path.equals("resources.ap_") || path.startsWith("res/");
    }

    private static boolean hasResources(List<ApplicationPatch> changes) {
        for (ApplicationPatch change : changes) {
            String path = change.getPath();
            if (!Server.isResourcePath(path)) continue;
            return true;
        }
        return false;
    }

    private int handlePatches(List<ApplicationPatch> changes, boolean hasResources, int updateMode) {
        if (hasResources) {
            FileManager.startUpdate();
        }
        for (ApplicationPatch change : changes) {
            String path = change.getPath();
            if (path.endsWith(".dex")) {
                Server.handleColdSwapPatch(change);
                boolean canHotSwap = false;
                for (ApplicationPatch c : changes) {
                    if (!c.getPath().equals("classes.dex.3")) continue;
                    canHotSwap = true;
                    break;
                }
                if (canHotSwap) continue;
                updateMode = 3;
                continue;
            }
            if (path.equals("classes.dex.3")) {
                updateMode = this.handleHotSwapPatch(updateMode, change);
                continue;
            }
            if (!Server.isResourcePath(path)) continue;
            updateMode = Server.handleResourcePatch(updateMode, change, path);
        }
        if (hasResources) {
            FileManager.finishUpdate(true);
        }
        return updateMode;
    }

    private static int handleResourcePatch(int updateMode, ApplicationPatch patch, String path) {
        if (Log.isLoggable((String)"InstantRun", (int)2)) {
            Log.v((String)"InstantRun", (String)("Received resource changes (" + path + ")"));
        }
        FileManager.writeAaptResources(path, patch.getBytes());
        updateMode = Math.max(updateMode, 2);
        return updateMode;
    }

    private int handleHotSwapPatch(int updateMode, ApplicationPatch patch) {
        if (Log.isLoggable((String)"InstantRun", (int)2)) {
            Log.v((String)"InstantRun", (String)"Received incremental code patch");
        }
        try {
            String dexFile = FileManager.writeTempDexFile(patch.getBytes());
            if (dexFile == null) {
                Log.e((String)"InstantRun", (String)"No file to write the code to");
                return updateMode;
            }
            if (Log.isLoggable((String)"InstantRun", (int)2)) {
                Log.v((String)"InstantRun", (String)("Reading live code from " + dexFile));
            }
            String nativeLibraryPath = FileManager.getNativeLibraryFolder().getPath();
            DexClassLoader dexClassLoader = new DexClassLoader(dexFile, this.mApplication.getCacheDir().getPath(), nativeLibraryPath, this.getClass().getClassLoader());
            Class<?> aClass = Class.forName("com.android.tools.fd.runtime.AppPatchesLoaderImpl", true, (ClassLoader)dexClassLoader);
            try {
                if (Log.isLoggable((String)"InstantRun", (int)2)) {
                    Log.v((String)"InstantRun", (String)("Got the patcher class " + aClass));
                }
                PatchesLoader loader = (PatchesLoader)aClass.newInstance();
                if (Log.isLoggable((String)"InstantRun", (int)2)) {
                    Log.v((String)"InstantRun", (String)("Got the patcher instance " + loader));
                }
                String[] getPatchedClasses = (String[])aClass.getDeclaredMethod("getPatchedClasses", new Class[0]).invoke((Object)loader, new Object[0]);
                if (Log.isLoggable((String)"InstantRun", (int)2)) {
                    Log.v((String)"InstantRun", (String)"Got the list of classes ");
                    for (String getPatchedClass : getPatchedClasses) {
                        Log.v((String)"InstantRun", (String)("class " + getPatchedClass));
                    }
                }
                if (!loader.load()) {
                    updateMode = 3;
                }
            }
            catch (Exception e) {
                Log.e((String)"InstantRun", (String)"Couldn't apply code changes", (Throwable)e);
                e.printStackTrace();
                updateMode = 3;
            }
        }
        catch (Throwable e) {
            Log.e((String)"InstantRun", (String)"Couldn't apply code changes", (Throwable)e);
            updateMode = 3;
        }
        return updateMode;
    }

    private static void handleColdSwapPatch(ApplicationPatch patch) {
        if (patch.path.startsWith("slice-")) {
            File file = FileManager.writeDexShard(patch.getBytes(), patch.path);
            if (Log.isLoggable((String)"InstantRun", (int)2)) {
                Log.v((String)"InstantRun", (String)("Received dex shard " + file));
            }
        }
    }

    private void restart(int updateMode, boolean incrementalResources, boolean toast) {
        if (Log.isLoggable((String)"InstantRun", (int)2)) {
            Log.v((String)"InstantRun", (String)("Finished loading changes; update mode =" + updateMode));
        }
        if (updateMode == 0 || updateMode == 1) {
            if (Log.isLoggable((String)"InstantRun", (int)2)) {
                Log.v((String)"InstantRun", (String)"Applying incremental code without restart");
            }
            if (toast) {
                Activity foreground = Restarter.getForegroundActivity((Context)this.mApplication);
                if (foreground != null) {
                    Restarter.showToast(foreground, "Applied code changes without activity restart");
                } else if (Log.isLoggable((String)"InstantRun", (int)2)) {
                    Log.v((String)"InstantRun", (String)"Couldn't show toast: no activity found");
                }
            }
            return;
        }
        List<Activity> activities = Restarter.getActivities((Context)this.mApplication, false);
        if (incrementalResources && updateMode == 2) {
            File file = FileManager.getExternalResourceFile();
            if (Log.isLoggable((String)"InstantRun", (int)2)) {
                Log.v((String)"InstantRun", (String)("About to update resource file=" + file + ", activities=" + activities));
            }
            if (file != null) {
                String resources = file.getPath();
                MonkeyPatcher.monkeyPatchApplication((Context)this.mApplication, null, null, resources);
                MonkeyPatcher.monkeyPatchExistingResources((Context)this.mApplication, resources, activities);
            } else {
                Log.e((String)"InstantRun", (String)"No resource file found to apply");
                updateMode = 3;
            }
        }
        Activity activity = Restarter.getForegroundActivity((Context)this.mApplication);
        if (updateMode == 2) {
            if (activity != null) {
                if (Log.isLoggable((String)"InstantRun", (int)2)) {
                    Log.v((String)"InstantRun", (String)"Restarting activity only!");
                }
                boolean handledRestart = false;
                try {
                    Method method = activity.getClass().getMethod("onHandleCodeChange", Long.TYPE);
                    Object result = method.invoke((Object)activity, 0L);
                    if (Log.isLoggable((String)"InstantRun", (int)2)) {
                        Log.v((String)"InstantRun", (String)("Activity " + activity + " provided manual restart method; return " + result));
                    }
                    if (Boolean.TRUE.equals(result)) {
                        handledRestart = true;
                        if (toast) {
                            Restarter.showToast(activity, "Applied changes");
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!handledRestart) {
                    if (toast) {
                        Restarter.showToast(activity, "Applied changes, restarted activity");
                    }
                    Restarter.restartActivityOnUiThread(activity);
                }
                return;
            }
            if (Log.isLoggable((String)"InstantRun", (int)2)) {
                Log.v((String)"InstantRun", (String)"No activity found, falling through to do a full app restart");
            }
            updateMode = 3;
        }
        if (updateMode != 3) {
            if (Log.isLoggable((String)"InstantRun", (int)6)) {
                Log.e((String)"InstantRun", (String)("Unexpected update mode: " + updateMode));
            }
            return;
        }
        if (Log.isLoggable((String)"InstantRun", (int)2)) {
            Log.v((String)"InstantRun", (String)"Waiting for app to be killed and restarted by the IDE...");
        }
    }

    private class SocketServerReplyThread
    extends Thread {
        private final LocalSocket mSocket;

        SocketServerReplyThread(LocalSocket socket) {
            this.mSocket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block13: {
                try {
                    DataInputStream input = new DataInputStream(this.mSocket.getInputStream());
                    DataOutputStream output = new DataOutputStream(this.mSocket.getOutputStream());
                    try {
                        this.handle(input, output);
                    }
                    finally {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                        try {
                            output.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (IOException e) {
                    if (!Log.isLoggable((String)"InstantRun", (int)2)) break block13;
                    Log.v((String)"InstantRun", (String)"Fatal error receiving messages", (Throwable)e);
                }
            }
        }

        private void handle(DataInputStream input, DataOutputStream output) throws IOException {
            int message;
            long magic = input.readLong();
            if (magic != 890269988L) {
                Log.w((String)"InstantRun", (String)("Unrecognized header format " + Long.toHexString(magic)));
                return;
            }
            int version = input.readInt();
            output.writeInt(4);
            if (version != 4) {
                Log.w((String)"InstantRun", (String)("Mismatched protocol versions; app is using version 4 and tool is using version " + version));
                return;
            }
            block9: while (true) {
                message = input.readInt();
                switch (message) {
                    case 7: {
                        if (Log.isLoggable((String)"InstantRun", (int)2)) {
                            Log.v((String)"InstantRun", (String)"Received EOF from the IDE");
                        }
                        return;
                    }
                    case 2: {
                        boolean active = Restarter.getForegroundActivity((Context)Server.this.mApplication) != null;
                        output.writeBoolean(active);
                        if (!Log.isLoggable((String)"InstantRun", (int)2)) continue block9;
                        Log.v((String)"InstantRun", (String)("Received Ping message from the IDE; returned active = " + active));
                        continue block9;
                    }
                    case 3: {
                        String path = input.readUTF();
                        long size = FileManager.getFileSize(path);
                        output.writeLong(size);
                        if (!Log.isLoggable((String)"InstantRun", (int)2)) continue block9;
                        Log.v((String)"InstantRun", (String)("Received path-exists(" + path + ") from the " + "IDE; returned size=" + size));
                        continue block9;
                    }
                    case 4: {
                        long begin = System.currentTimeMillis();
                        String path = input.readUTF();
                        byte[] checksum = FileManager.getCheckSum(path);
                        if (checksum != null) {
                            output.writeInt(checksum.length);
                            output.write(checksum);
                            if (!Log.isLoggable((String)"InstantRun", (int)2)) continue block9;
                            long end = System.currentTimeMillis();
                            String hash = new BigInteger(1, checksum).toString(16);
                            Log.v((String)"InstantRun", (String)("Received checksum(" + path + ") from the " + "IDE: took " + (end - begin) + "ms to compute " + hash));
                            continue block9;
                        }
                        output.writeInt(0);
                        if (!Log.isLoggable((String)"InstantRun", (int)2)) continue block9;
                        Log.v((String)"InstantRun", (String)("Received checksum(" + path + ") from the " + "IDE: returning <null>"));
                        continue block9;
                    }
                    case 5: {
                        if (!this.authenticate(input)) {
                            return;
                        }
                        Activity activity = Restarter.getForegroundActivity((Context)Server.this.mApplication);
                        if (activity == null) continue block9;
                        if (Log.isLoggable((String)"InstantRun", (int)2)) {
                            Log.v((String)"InstantRun", (String)"Restarting activity per user request");
                        }
                        Restarter.restartActivityOnUiThread(activity);
                        continue block9;
                    }
                    case 1: {
                        if (!this.authenticate(input)) {
                            return;
                        }
                        List<ApplicationPatch> changes = ApplicationPatch.read(input);
                        if (changes == null) continue block9;
                        boolean hasResources = Server.hasResources(changes);
                        int updateMode = input.readInt();
                        updateMode = Server.this.handlePatches(changes, hasResources, updateMode);
                        boolean showToast = input.readBoolean();
                        output.writeBoolean(true);
                        Server.this.restart(updateMode, hasResources, showToast);
                        continue block9;
                    }
                    case 6: {
                        String text = input.readUTF();
                        Activity foreground = Restarter.getForegroundActivity((Context)Server.this.mApplication);
                        if (foreground != null) {
                            Restarter.showToast(foreground, text);
                            continue block9;
                        }
                        if (!Log.isLoggable((String)"InstantRun", (int)2)) continue block9;
                        Log.v((String)"InstantRun", (String)("Couldn't show toast (no activity) : " + text));
                        continue block9;
                    }
                }
                break;
            }
            if (Log.isLoggable((String)"InstantRun", (int)6)) {
                Log.e((String)"InstantRun", (String)("Unexpected message type: " + message));
            }
        }

        private boolean authenticate(DataInputStream input) throws IOException {
            long token = input.readLong();
            if (token != AppInfo.token) {
                Log.w((String)"InstantRun", (String)("Mismatched identity token from client; received " + token + " and expected " + AppInfo.token));
                sWrongTokenCount++;
                return false;
            }
            return true;
        }
    }

    private class SocketServerThread
    extends Thread {
        private SocketServerThread() {
        }

        @Override
        public void run() {
            block2: while (true) {
                try {
                    LocalServerSocket serverSocket;
                    while ((serverSocket = Server.this.mServerSocket) != null) {
                        LocalSocket socket = serverSocket.accept();
                        if (Log.isLoggable((String)"InstantRun", (int)2)) {
                            Log.v((String)"InstantRun", (String)"Received connection from IDE: spawning connection thread");
                        }
                        SocketServerReplyThread socketServerReplyThread = new SocketServerReplyThread(socket);
                        socketServerReplyThread.run();
                        if (sWrongTokenCount <= 50) continue;
                        if (Log.isLoggable((String)"InstantRun", (int)2)) {
                            Log.v((String)"InstantRun", (String)"Stopping server: too many wrong token connections");
                        }
                        Server.this.mServerSocket.close();
                        break block2;
                    }
                }
                catch (Throwable e) {
                    if (!Log.isLoggable((String)"InstantRun", (int)2)) continue;
                    Log.v((String)"InstantRun", (String)"Fatal error accepting connection on local socket", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

