/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.support.v4.print.PrintHelperApi20;
import android.support.v4.print.PrintHelperApi23;
import android.support.v4.print.PrintHelperApi24;
import android.support.v4.print.PrintHelperKitkat;
import java.io.FileNotFoundException;

public final class PrintHelper {
    public static final int SCALE_MODE_FIT = 1;
    public static final int SCALE_MODE_FILL = 2;
    public static final int COLOR_MODE_MONOCHROME = 1;
    public static final int COLOR_MODE_COLOR = 2;
    public static final int ORIENTATION_LANDSCAPE = 1;
    public static final int ORIENTATION_PORTRAIT = 2;
    PrintHelperVersionImpl mImpl;

    public static boolean systemSupportsPrint() {
        return Build.VERSION.SDK_INT >= 19;
    }

    public PrintHelper(Context context) {
        this.mImpl = PrintHelper.systemSupportsPrint() ? (Build.VERSION.SDK_INT >= 24 ? new PrintHelperApi24Impl(context) : (Build.VERSION.SDK_INT >= 23 ? new PrintHelperApi23Impl(context) : (Build.VERSION.SDK_INT >= 20 ? new PrintHelperApi20Impl(context) : new PrintHelperKitkatImpl(context)))) : new PrintHelperStubImpl();
    }

    public void setScaleMode(int scaleMode) {
        this.mImpl.setScaleMode(scaleMode);
    }

    public int getScaleMode() {
        return this.mImpl.getScaleMode();
    }

    public void setColorMode(int colorMode) {
        this.mImpl.setColorMode(colorMode);
    }

    public int getColorMode() {
        return this.mImpl.getColorMode();
    }

    public void setOrientation(int orientation) {
        this.mImpl.setOrientation(orientation);
    }

    public int getOrientation() {
        return this.mImpl.getOrientation();
    }

    public void printBitmap(String jobName, Bitmap bitmap) {
        this.mImpl.printBitmap(jobName, bitmap, null);
    }

    public void printBitmap(String jobName, Bitmap bitmap, OnPrintFinishCallback callback) {
        this.mImpl.printBitmap(jobName, bitmap, callback);
    }

    public void printBitmap(String jobName, Uri imageFile) throws FileNotFoundException {
        this.mImpl.printBitmap(jobName, imageFile, null);
    }

    public void printBitmap(String jobName, Uri imageFile, OnPrintFinishCallback callback) throws FileNotFoundException {
        this.mImpl.printBitmap(jobName, imageFile, callback);
    }

    private static final class PrintHelperApi24Impl
    extends PrintHelperImpl<PrintHelperApi24> {
        PrintHelperApi24Impl(Context context) {
            super(new PrintHelperApi24(context));
        }
    }

    private static final class PrintHelperApi23Impl
    extends PrintHelperImpl<PrintHelperApi23> {
        PrintHelperApi23Impl(Context context) {
            super(new PrintHelperApi23(context));
        }
    }

    private static final class PrintHelperApi20Impl
    extends PrintHelperImpl<PrintHelperApi20> {
        PrintHelperApi20Impl(Context context) {
            super(new PrintHelperApi20(context));
        }
    }

    private static final class PrintHelperKitkatImpl
    extends PrintHelperImpl<PrintHelperKitkat> {
        PrintHelperKitkatImpl(Context context) {
            super(new PrintHelperKitkat(context));
        }
    }

    private static class PrintHelperImpl<RealHelper extends PrintHelperKitkat>
    implements PrintHelperVersionImpl {
        private final RealHelper mPrintHelper;

        protected PrintHelperImpl(RealHelper helper) {
            this.mPrintHelper = helper;
        }

        @Override
        public void setScaleMode(int scaleMode) {
            ((PrintHelperKitkat)this.mPrintHelper).setScaleMode(scaleMode);
        }

        @Override
        public int getScaleMode() {
            return ((PrintHelperKitkat)this.mPrintHelper).getScaleMode();
        }

        @Override
        public void setColorMode(int colorMode) {
            ((PrintHelperKitkat)this.mPrintHelper).setColorMode(colorMode);
        }

        @Override
        public int getColorMode() {
            return ((PrintHelperKitkat)this.mPrintHelper).getColorMode();
        }

        @Override
        public void setOrientation(int orientation) {
            ((PrintHelperKitkat)this.mPrintHelper).setOrientation(orientation);
        }

        @Override
        public int getOrientation() {
            return ((PrintHelperKitkat)this.mPrintHelper).getOrientation();
        }

        @Override
        public void printBitmap(String jobName, Bitmap bitmap, final OnPrintFinishCallback callback) {
            PrintHelperKitkat.OnPrintFinishCallback delegateCallback = null;
            if (callback != null) {
                delegateCallback = new PrintHelperKitkat.OnPrintFinishCallback(){

                    @Override
                    public void onFinish() {
                        callback.onFinish();
                    }
                };
            }
            ((PrintHelperKitkat)this.mPrintHelper).printBitmap(jobName, bitmap, delegateCallback);
        }

        @Override
        public void printBitmap(String jobName, Uri imageFile, final OnPrintFinishCallback callback) throws FileNotFoundException {
            PrintHelperKitkat.OnPrintFinishCallback delegateCallback = null;
            if (callback != null) {
                delegateCallback = new PrintHelperKitkat.OnPrintFinishCallback(){

                    @Override
                    public void onFinish() {
                        callback.onFinish();
                    }
                };
            }
            ((PrintHelperKitkat)this.mPrintHelper).printBitmap(jobName, imageFile, delegateCallback);
        }
    }

    private static final class PrintHelperStubImpl
    implements PrintHelperVersionImpl {
        int mScaleMode = 2;
        int mColorMode = 2;
        int mOrientation = 1;

        private PrintHelperStubImpl() {
        }

        @Override
        public void setScaleMode(int scaleMode) {
            this.mScaleMode = scaleMode;
        }

        @Override
        public int getColorMode() {
            return this.mColorMode;
        }

        @Override
        public void setColorMode(int colorMode) {
            this.mColorMode = colorMode;
        }

        @Override
        public void setOrientation(int orientation) {
            this.mOrientation = orientation;
        }

        @Override
        public int getOrientation() {
            return this.mOrientation;
        }

        @Override
        public int getScaleMode() {
            return this.mScaleMode;
        }

        @Override
        public void printBitmap(String jobName, Bitmap bitmap, OnPrintFinishCallback callback) {
        }

        @Override
        public void printBitmap(String jobName, Uri imageFile, OnPrintFinishCallback callback) {
        }
    }

    static interface PrintHelperVersionImpl {
        public void setScaleMode(int var1);

        public int getScaleMode();

        public void setColorMode(int var1);

        public int getColorMode();

        public void setOrientation(int var1);

        public int getOrientation();

        public void printBitmap(String var1, Bitmap var2, OnPrintFinishCallback var3);

        public void printBitmap(String var1, Uri var2, OnPrintFinishCallback var3) throws FileNotFoundException;
    }

    public static interface OnPrintFinishCallback {
        public void onFinish();
    }
}

