/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media.session;

import android.annotation.TargetApi;
import android.media.Rating;
import android.media.RemoteControlClient;
import android.os.Bundle;
import android.support.annotation.RequiresApi;
import android.support.v4.media.session.MediaSessionCompatApi14;
import android.support.v4.media.session.MediaSessionCompatApi18;

@RequiresApi(value=19)
@TargetApi(value=19)
class MediaSessionCompatApi19 {
    private static final long ACTION_SET_RATING = 128L;
    private static final String METADATA_KEY_USER_RATING = "android.media.metadata.USER_RATING";
    private static final String METADATA_KEY_RATING = "android.media.metadata.RATING";
    private static final String METADATA_KEY_YEAR = "android.media.metadata.YEAR";

    MediaSessionCompatApi19() {
    }

    public static void setTransportControlFlags(Object rccObj, long actions) {
        ((RemoteControlClient)rccObj).setTransportControlFlags(MediaSessionCompatApi19.getRccTransportControlFlagsFromActions(actions));
    }

    public static Object createMetadataUpdateListener(Callback callback) {
        return new OnMetadataUpdateListener<Callback>(callback);
    }

    public static void setMetadata(Object rccObj, Bundle metadata, long actions) {
        RemoteControlClient.MetadataEditor editor = ((RemoteControlClient)rccObj).editMetadata(true);
        MediaSessionCompatApi14.buildOldMetadata(metadata, editor);
        MediaSessionCompatApi19.addNewMetadata(metadata, editor);
        if ((actions & 0x80L) != 0L) {
            editor.addEditableKey(0x10000001);
        }
        editor.apply();
    }

    public static void setOnMetadataUpdateListener(Object rccObj, Object onMetadataUpdateObj) {
        ((RemoteControlClient)rccObj).setMetadataUpdateListener((RemoteControlClient.OnMetadataUpdateListener)onMetadataUpdateObj);
    }

    static int getRccTransportControlFlagsFromActions(long actions) {
        int transportControlFlags = MediaSessionCompatApi18.getRccTransportControlFlagsFromActions(actions);
        if ((actions & 0x80L) != 0L) {
            transportControlFlags |= 0x200;
        }
        return transportControlFlags;
    }

    static void addNewMetadata(Bundle metadata, RemoteControlClient.MetadataEditor editor) {
        if (metadata == null) {
            return;
        }
        if (metadata.containsKey(METADATA_KEY_YEAR)) {
            editor.putLong(8, metadata.getLong(METADATA_KEY_YEAR));
        }
        if (metadata.containsKey(METADATA_KEY_RATING)) {
            editor.putObject(101, (Object)metadata.getParcelable(METADATA_KEY_RATING));
        }
        if (metadata.containsKey(METADATA_KEY_USER_RATING)) {
            editor.putObject(0x10000001, (Object)metadata.getParcelable(METADATA_KEY_USER_RATING));
        }
    }

    static interface Callback
    extends MediaSessionCompatApi18.Callback {
        public void onSetRating(Object var1);
    }

    static class OnMetadataUpdateListener<T extends Callback>
    implements RemoteControlClient.OnMetadataUpdateListener {
        protected final T mCallback;

        public OnMetadataUpdateListener(T callback) {
            this.mCallback = callback;
        }

        public void onMetadataUpdate(int key, Object newValue) {
            if (key == 0x10000001 && newValue instanceof Rating) {
                this.mCallback.onSetRating(newValue);
            }
        }
    }
}

