/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.fd.runtime;

import android.content.Context;
import android.util.Log;
import com.android.tools.fd.runtime.AppInfo;
import com.android.tools.fd.runtime.Paths;
import com.android.tools.fd.runtime.Restarter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileManager {
    private static final boolean USE_EXTRACTED_RESOURCES = false;
    private static final String RESOURCE_FILE_NAME = "resources.ap_";
    private static final String RESOURCE_FOLDER_NAME = "resources";
    private static final String FILE_NAME_ACTIVE = "active";
    private static final String FOLDER_NAME_LEFT = "left";
    private static final String FOLDER_NAME_RIGHT = "right";
    private static final String RELOAD_DEX_PREFIX = "reload";
    public static final String CLASSES_DEX_SUFFIX = ".dex";
    private static boolean sHavePurgedTempDexFolder;

    private static File getDataFolder() {
        return new File(Paths.getDataDirectory(AppInfo.applicationId));
    }

    private static File getResourceFile(File base) {
        return new File(base, RESOURCE_FILE_NAME);
    }

    private static File getDexFileFolder(File base, boolean createIfNecessary) {
        boolean created;
        File file = new File(base, "dex");
        if (createIfNecessary && !file.isDirectory() && !(created = file.mkdirs())) {
            Log.e((String)"InstantRun", (String)("Failed to create directory " + file));
            return null;
        }
        return file;
    }

    private static File getTempDexFileFolder(File base) {
        return new File(base, "dex-temp");
    }

    public static File getNativeLibraryFolder() {
        return new File(Paths.getMainApkDataDirectory(AppInfo.applicationId), "lib");
    }

    public static File getReadFolder() {
        String name = FileManager.leftIsActive() ? FOLDER_NAME_LEFT : FOLDER_NAME_RIGHT;
        return new File(FileManager.getDataFolder(), name);
    }

    public static void swapFolders() {
        FileManager.setLeftActive(!FileManager.leftIsActive());
    }

    public static File getWriteFolder(boolean wipe) {
        String name = FileManager.leftIsActive() ? FOLDER_NAME_RIGHT : FOLDER_NAME_LEFT;
        File folder = new File(FileManager.getDataFolder(), name);
        if (wipe && folder.exists()) {
            FileManager.delete(folder);
            boolean mkdirs = folder.mkdirs();
            if (!mkdirs) {
                Log.e((String)"InstantRun", (String)("Failed to create folder " + folder));
            }
        }
        return folder;
    }

    private static void delete(File file) {
        boolean deleted;
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File child : files) {
                FileManager.delete(child);
            }
        }
        if (!(deleted = file.delete())) {
            Log.e((String)"InstantRun", (String)("Failed to delete file " + file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean leftIsActive() {
        boolean bl;
        File folder = FileManager.getDataFolder();
        File pointer = new File(folder, FILE_NAME_ACTIVE);
        if (!pointer.exists()) {
            return true;
        }
        BufferedReader reader = new BufferedReader(new FileReader(pointer));
        try {
            String line = reader.readLine();
            bl = FOLDER_NAME_LEFT.equals(line);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException ignore) {
                return true;
            }
        }
        reader.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setLeftActive(boolean active) {
        File folder = FileManager.getDataFolder();
        File pointer = new File(folder, FILE_NAME_ACTIVE);
        if (pointer.exists()) {
            boolean deleted = pointer.delete();
            if (!deleted) {
                Log.e((String)"InstantRun", (String)("Failed to delete file " + pointer));
            }
        } else if (!folder.exists()) {
            boolean create = folder.mkdirs();
            if (!create) {
                Log.e((String)"InstantRun", (String)("Failed to create directory " + folder));
            }
            return;
        }
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(pointer), "UTF-8"));
            try {
                writer.write(active ? FOLDER_NAME_LEFT : FOLDER_NAME_RIGHT);
            }
            finally {
                ((Writer)writer).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void checkInbox() {
        File resources;
        File inbox = new File(Paths.getInboxDirectory(AppInfo.applicationId));
        if (inbox.isDirectory() && (resources = new File(inbox, RESOURCE_FILE_NAME)).isFile()) {
            byte[] bytes;
            if (Log.isLoggable((String)"InstantRun", (int)2)) {
                Log.v((String)"InstantRun", (String)("Processing resource file from inbox (" + resources + ")"));
            }
            if ((bytes = FileManager.readRawBytes(resources)) != null) {
                FileManager.startUpdate();
                FileManager.writeAaptResources(RESOURCE_FILE_NAME, bytes);
                FileManager.finishUpdate(true);
                boolean deleted = resources.delete();
                if (!deleted && Log.isLoggable((String)"InstantRun", (int)6)) {
                    Log.e((String)"InstantRun", (String)("Couldn't remove inbox resource file: " + resources));
                }
            }
        }
    }

    public static File getExternalResourceFile() {
        File file = FileManager.getResourceFile(FileManager.getReadFolder());
        if (!file.exists()) {
            if (Log.isLoggable((String)"InstantRun", (int)2)) {
                Log.v((String)"InstantRun", (String)"Cannot find external resources, not patching them in");
            }
            return null;
        }
        return file;
    }

    public static List<String> getDexList(Context context, long apkModified) {
        File[] dexFiles;
        File dataFolder = FileManager.getDataFolder();
        long newestHotswapPatch = FileManager.getMostRecentTempDexTime(dataFolder);
        File dexFolder = FileManager.getDexFileFolder(dataFolder, false);
        boolean extractedSlices = false;
        if (dexFolder == null || !dexFolder.isDirectory()) {
            if (Log.isLoggable((String)"InstantRun", (int)2)) {
                Log.v((String)"InstantRun", (String)"No local dex slice folder: First run since installation.");
            }
            if ((dexFolder = FileManager.getDexFileFolder(dataFolder, true)) == null) {
                Log.wtf((String)"InstantRun", (String)"Couldn't create dex code folder");
                return Collections.emptyList();
            }
            dexFiles = FileManager.extractSlices(dexFolder, null, -1L);
            extractedSlices = dexFiles.length > 0;
        } else {
            dexFiles = dexFolder.listFiles();
        }
        if (dexFiles == null || dexFiles.length == 0) {
            if (Log.isLoggable((String)"InstantRun", (int)2)) {
                Log.v((String)"InstantRun", (String)"Cannot find dex classes, not patching them in");
            }
            return Collections.emptyList();
        }
        long newestColdswapPatch = apkModified;
        if (!extractedSlices && dexFiles.length > 0) {
            long oldestColdSwapPatch = apkModified;
            File[] fileArray = dexFiles;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File dex = fileArray[i];
                long dexModified = dex.lastModified();
                oldestColdSwapPatch = Math.min(dexModified, oldestColdSwapPatch);
                newestColdswapPatch = Math.max(dexModified, newestColdswapPatch);
            }
            if (oldestColdSwapPatch < apkModified) {
                if (Log.isLoggable((String)"InstantRun", (int)2)) {
                    Log.v((String)"InstantRun", (String)"One or more slices were older than APK: extracting newer slices");
                }
                dexFiles = FileManager.extractSlices(dexFolder, dexFiles, apkModified);
            }
        } else if (newestHotswapPatch > 0L) {
            FileManager.purgeTempDexFiles(dataFolder);
        }
        if (newestHotswapPatch > newestColdswapPatch) {
            String message = "Your app does not have the latest code changes because it was restarted manually. Please run from IDE instead.";
            if (Log.isLoggable((String)"InstantRun", (int)2)) {
                Log.v((String)"InstantRun", (String)message);
            }
            Restarter.showToastWhenPossible(context, message);
        }
        ArrayList<String> list = new ArrayList<String>(dexFiles.length);
        for (File dex : dexFiles) {
            if (!dex.getName().endsWith(CLASSES_DEX_SUFFIX)) continue;
            list.add(dex.getPath());
        }
        Collections.sort(list, Collections.reverseOrder());
        return list;
    }

    /*
     * Exception decompiling
     */
    private static File[] extractSlices(File dexFolder, File[] dexFolderFiles, long apkModified) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 30[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static File getTempDexFile() {
        File dataFolder = FileManager.getDataFolder();
        File dexFolder = FileManager.getTempDexFileFolder(dataFolder);
        if (!dexFolder.exists()) {
            boolean created = dexFolder.mkdirs();
            if (!created) {
                Log.e((String)"InstantRun", (String)("Failed to create directory " + dexFolder));
                return null;
            }
            sHavePurgedTempDexFolder = true;
        } else if (!sHavePurgedTempDexFolder) {
            FileManager.purgeTempDexFiles(dataFolder);
        }
        File[] files = dexFolder.listFiles();
        int max = -1;
        if (files != null) {
            for (File file : files) {
                String name = file.getName();
                if (!name.startsWith(RELOAD_DEX_PREFIX) || !name.endsWith(CLASSES_DEX_SUFFIX)) continue;
                String middle = name.substring(RELOAD_DEX_PREFIX.length(), name.length() - CLASSES_DEX_SUFFIX.length());
                try {
                    int version = Integer.decode(middle);
                    if (version <= max) continue;
                    max = version;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        String fileName = String.format("%s0x%04x%s", RELOAD_DEX_PREFIX, max + 1, CLASSES_DEX_SUFFIX);
        File file = new File(dexFolder, fileName);
        if (Log.isLoggable((String)"InstantRun", (int)2)) {
            Log.v((String)"InstantRun", (String)("Writing new dex file: " + file));
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeRawBytes(File destination, byte[] bytes) {
        boolean bl;
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(destination));
        try {
            output.write(bytes);
            output.flush();
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                output.close();
                throw throwable;
            }
            catch (IOException ioe) {
                Log.wtf((String)"InstantRun", (String)("Failed to write file, clean project and rebuild " + destination), (Throwable)ioe);
                throw new RuntimeException(String.format("InstantRun could not write file %1$s, clean project and rebuild ", destination));
            }
        }
        output.close();
        return bl;
    }

    public static boolean extractZip(File destination, byte[] zipBytes) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(zipBytes);
        return FileManager.extractZip(destination, inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean extractZip(File destDir, InputStream inputStream) {
        boolean bl;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            byte[] buffer = new byte[2000];
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                if (!name.startsWith("META-INF") && !entry.isDirectory()) {
                    boolean created;
                    File dest = new File(destDir, name);
                    File parent = dest.getParentFile();
                    if (parent != null && !parent.exists() && !(created = parent.mkdirs())) {
                        Log.e((String)"InstantRun", (String)("Failed to create directory " + dest));
                        boolean bl2 = false;
                        return bl2;
                    }
                    BufferedOutputStream src = new BufferedOutputStream(new FileOutputStream(dest));
                    try {
                        int bytesRead;
                        while ((bytesRead = zipInputStream.read(buffer)) != -1) {
                            ((OutputStream)src).write(buffer, 0, bytesRead);
                        }
                    }
                    finally {
                        ((OutputStream)src).close();
                    }
                }
                entry = zipInputStream.getNextEntry();
            }
            bl = true;
        }
        catch (IOException ioe) {
            Log.e((String)"InstantRun", (String)("Failed to extract zip contents into directory " + destDir), (Throwable)ioe);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                zipInputStream.close();
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    public static void startUpdate() {
        FileManager.getWriteFolder(true);
    }

    public static void finishUpdate(boolean wroteResources) {
        if (wroteResources) {
            FileManager.swapFolders();
        }
    }

    public static File writeDexShard(byte[] bytes, String name) {
        File dexFolder = FileManager.getDexFileFolder(FileManager.getDataFolder(), true);
        if (dexFolder == null) {
            return null;
        }
        File file = new File(dexFolder, name);
        FileManager.writeRawBytes(file, bytes);
        return file;
    }

    public static void writeAaptResources(String relativePath, byte[] bytes) {
        boolean created;
        File resourceFile = FileManager.getResourceFile(FileManager.getWriteFolder(false));
        File file = resourceFile;
        File folder = file.getParentFile();
        if (!folder.isDirectory() && !(created = folder.mkdirs())) {
            if (Log.isLoggable((String)"InstantRun", (int)2)) {
                Log.v((String)"InstantRun", (String)("Cannot create local resource file directory " + folder));
            }
            return;
        }
        if (relativePath.equals(RESOURCE_FILE_NAME)) {
            FileManager.writeRawBytes(file, bytes);
        } else {
            FileManager.writeRawBytes(file, bytes);
        }
    }

    public static String writeTempDexFile(byte[] bytes) {
        File file = FileManager.getTempDexFile();
        if (file != null) {
            FileManager.writeRawBytes(file, bytes);
            return file.getPath();
        }
        Log.e((String)"InstantRun", (String)"No file to write temp dex content to");
        return null;
    }

    public static long getMostRecentTempDexTime(File dataFolder) {
        File dexFolder = FileManager.getTempDexFileFolder(dataFolder);
        if (!dexFolder.isDirectory()) {
            return 0L;
        }
        File[] files = dexFolder.listFiles();
        if (files == null) {
            return 0L;
        }
        long newest = 0L;
        for (File file : files) {
            if (!file.getPath().endsWith(CLASSES_DEX_SUFFIX)) continue;
            newest = Math.max(newest, file.lastModified());
        }
        return newest;
    }

    public static void purgeTempDexFiles(File dataFolder) {
        sHavePurgedTempDexFolder = true;
        File dexFolder = FileManager.getTempDexFileFolder(dataFolder);
        if (!dexFolder.isDirectory()) {
            return;
        }
        File[] files = dexFolder.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            boolean deleted;
            if (!file.getPath().endsWith(CLASSES_DEX_SUFFIX) || (deleted = file.delete())) continue;
            Log.e((String)"InstantRun", (String)("Could not delete temp dex file " + file));
        }
    }

    public static long getFileSize(String path) {
        File file;
        if (path.equals(RESOURCE_FILE_NAME) && (file = FileManager.getExternalResourceFile()) != null) {
            return file.length();
        }
        return -1L;
    }

    public static byte[] getCheckSum(String path) {
        File file;
        if (path.equals(RESOURCE_FILE_NAME) && (file = FileManager.getExternalResourceFile()) != null) {
            return FileManager.getCheckSum(file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getCheckSum(File file) {
        block10: {
            byte[] byArray;
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[4096];
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
            try {
                int read;
                while ((read = input.read(buffer)) != -1) {
                    digest.update(buffer, 0, read);
                }
                byArray = digest.digest();
            }
            catch (Throwable throwable) {
                try {
                    input.close();
                    throw throwable;
                }
                catch (NoSuchAlgorithmException e) {
                    if (Log.isLoggable((String)"InstantRun", (int)6)) {
                        Log.e((String)"InstantRun", (String)"Couldn't look up message digest", (Throwable)e);
                    }
                    break block10;
                }
                catch (IOException ioe) {
                    if (Log.isLoggable((String)"InstantRun", (int)6)) {
                        Log.e((String)"InstantRun", (String)("Failed to read file " + file), (Throwable)ioe);
                    }
                    break block10;
                }
                catch (Throwable t) {
                    if (!Log.isLoggable((String)"InstantRun", (int)6)) break block10;
                    Log.e((String)"InstantRun", (String)"Unexpected checksum exception", (Throwable)t);
                }
            }
            input.close();
            return byArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readRawBytes(File source) {
        byte[] byArray;
        long length;
        if (Log.isLoggable((String)"InstantRun", (int)2)) {
            Log.v((String)"InstantRun", (String)("Reading the bytes for file " + source));
        }
        if ((length = source.length()) > Integer.MAX_VALUE) {
            if (Log.isLoggable((String)"InstantRun", (int)2)) {
                Log.v((String)"InstantRun", (String)("File too large (" + length + ")"));
            }
            return null;
        }
        byte[] result = new byte[(int)length];
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(source));
        try {
            int numRead;
            int index = 0;
            for (int remaining = result.length - index; remaining > 0 && (numRead = input.read(result, index, remaining)) != -1; remaining -= numRead) {
                index += numRead;
            }
            if (Log.isLoggable((String)"InstantRun", (int)2)) {
                Log.v((String)"InstantRun", (String)("Returning length " + result.length + " for file " + source));
            }
            byArray = result;
        }
        catch (Throwable throwable) {
            try {
                input.close();
                throw throwable;
            }
            catch (IOException ioe) {
                if (Log.isLoggable((String)"InstantRun", (int)6)) {
                    Log.e((String)"InstantRun", (String)("Failed to read file " + source), (Throwable)ioe);
                }
                if (Log.isLoggable((String)"InstantRun", (int)2)) {
                    Log.v((String)"InstantRun", (String)("I/O error, no bytes returned for " + source));
                }
                return null;
            }
        }
        input.close();
        return byArray;
    }
}

